<?php
namespace Codexpert\CoDesigner_Pro\Modules;
use Codexpert\Plugin\Base;
use Elementor\Plugin as Elementor;
use Codexpert\CoDesigner_Pro\Helper;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

class Email_Templates extends Base {

	public $slug;
	public $name;
	public $version;

	/**
	 * Constructor function
	 */
	public function __construct() {
        include_once( dirname( __FILE__ ) . '/inc/functions.php' );

		$this->plugin	= get_plugin_data( CODESIGNER_PRO );
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->version	= $this->plugin['Version'];

		$this->filter( 'wc_get_template', 'change_content', 11, 5 );
		$this->filter( 'woocommerce_email_styles', 'change_styles', 11, 2 );
		$this->filter( 'woocommerce_email_styles', 'test_email_css', 11, 2 );
		$this->action( 'woocommerce_new_order', 'generate_global_order_id', 10, 2 );

        // register widget
		$this->action( 'elementor/widgets/register', 'register_widget' );

        // register scripts
		$this->action( 'wp_enqueue_scripts', 'enqueue_scripts' );
        $this->action( 'elementor/editor/after_enqueue_scripts', 'enqueue_scripts' );

		$this->filter( 'codesigner_email_replace_placeholders', 'replace_placeholders', 10, 2 );
		$this->priv( 'wcd-test-email', 'test_email' );
	}

	public function __settings ( $settings ) {

		$email_templates	= Helper::get_posts( [ 'post_type' => 'elementor_library', 'meta_key' => '_elementor_template_type', 'meta_value' => 'wl-email' ] );
		$email_templates	= [ '' => __( 'Use WooCommerce Default', 'codesigner-pro' ) ] + $email_templates;
		$add_new_url		= add_query_arg( [ 'post_type' => 'elementor_library', 'tabs_group' => 'library', 'elementor_library_type' => 'wl-email' ], admin_url( 'edit.php' ) );
		$settings['sections'][ 'codesigner_email_designer' ] = [
			'id'        => 'codesigner_email_designer',
			'label'     => __( ' Email Designer', 'codesigner' ),
			'icon'      => 'dashicons-email-alt',
			'sticky'	=> false,
			'fields'    => [
				'enable-email-designer-template' => [
					'id'      	=> 'enable-email-designer-template',
					'label'     => __( 'Enable Email Designer Template', 'codesigner-pro' ),
					'type'      => 'switch',
					'default' 	=> false,
					'desc' 		=> __( 'This will enable the new Email Designer Template', 'codesigner-pro' ), 
				],
				'emails-tab' => [
					'id'      => 'emails-tab',
					'label'     => __( 'Customer Emails' ),
					'type'      => 'tabs',
					'items'     => [
						'customer-emails' => [
							'id'      => 'customer-emails',
							'label'     => __( 'Customer Emails', 'codesigner-pro' ),
							'fields'    => [
								'customer-completed-order' => [
									'id'      	=> 'customer-completed-order',
									'label'     => __( 'Completed Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Completed Order', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-invoice' => [
									'id'      	=> 'customer-invoice',
									'label'     => __( 'Customer Invoice', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Customer Invoice', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-new-account' => [
									'id'      	=> 'customer-new-account',
									'label'     => __( 'New Account', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'New Account', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-note' => [
									'id'      	=> 'customer-note',
									'label'     => __( 'Customer Note', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Customer Note', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-on-hold-order' => [
									'id'      	=> 'customer-on-hold-order',
									'label'     => __( 'On-hold Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'On-hold', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-processing-order' => [
									'id'      	=> 'customer-processing-order',
									'label'     => __( 'Processing Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Processing Order', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-refunded-order' => [
									'id'      	=> 'customer-refunded-order',
									'label'     => __( 'Refunded Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Refunded Order', 'codesigner-pro' ), $add_new_url ),
								],
								'customer-reset-password' => [
									'id'      	=> 'customer-reset-password',
									'label'     => __( 'Reset Password', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Reset Password', 'codesigner-pro' ), $add_new_url ),
								],
							],
						],
						'admin-emails' => [
							'id'      => 'admin-emails',
							'label'     => __( 'Admin Emails', 'codesigner-pro' ),
							'fields'    => [
								'admin-new-order' => [
									'id'      	=> 'admin-new-order',
									'label'     => __( 'New Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'New Order', 'codesigner-pro' ), $add_new_url ),
								],
								'admin-cancelled-order' => [
									'id'      	=> 'admin-cancelled-order',
									'label'     => __( 'Cancelled Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Cancelled Order', 'codesigner-pro' ), $add_new_url ),
								],
								'admin-failed-order' => [
									'id'      	=> 'admin-failed-order',
									'label'     => __( 'Failed Order', 'codesigner-pro' ),
									'type'      => 'select',
									'chosen'	=> true,
									'options'	=> $email_templates,
									'desc'      => sprintf( __( 'Choose a template that\'ll replace WooCommerce\'s <strong>%s</strong> email. <a href="%s" target="_blank">Create one</a> if you haven\'t created any.', 'codesigner-pro' ), __( 'Failed Order', 'codesigner-pro' ), $add_new_url ),
								],
							],
						],
					],
				],
			],
		];

		return $settings;
	}

	public static function get_active_designers() {
		$_designers = get_option( 'codesigner_email_designer' );
		$designers = [];

		if( $_designers && count( $_designers ) > 0 ) {
			foreach ( $_designers as $designer => $template_id ) {
				if( $template_id != '' ) {
					$designers[ $designer ] = $template_id;
				}
			}
		}

		return $designers;
	}

	public function get_designer_template_id( $wc_template ) {
		$designers = $this->get_active_designers();

		if( isset( $designers[ $wc_template ] ) ) {
			return $designers[ $wc_template ];
		}

		return false;
	}

	public function change_content( $template, $template_name, $args, $template_path, $default_path ) {

		$template_base_name = str_replace( [ 'emails/', '.php' ], [], $template_name );

		if( false !== ( $template_id = $this->get_designer_template_id( $template_base_name ) ) ) {

			$_REQUEST['template_id'] = $template_id;

			return trailingslashit( CODESIGNER_PRO_DIR ) . 'modules/email-templates/views/email.php';
		}

		return $template;
	}

	public function change_styles( $styles, $object ) {

		$template_base_name = str_replace( [ 'emails/', '.php' ], [], $object->template_html );

		if( false === ( $template_id = $this->get_designer_template_id( $template_base_name ) ) ) return $styles;
		ob_start();
		echo wcd_get_template_css( $template_id );
		return ob_get_clean();
	}

	public function register_widget( $widgets_manager ) {
		require_once( dirname( __FILE__ ) . '/widgets/email-designer-widget.php' );

		$new_email_designer = Helper::get_option( 'codesigner_email_designer', 'enable-email-designer-template', false );

		if ( $new_email_designer ) $widgets_manager->register( new \Email_Designer_Widget() );
	}

	public function enqueue_scripts() {
		$css_files = [
			'common', 
			'admin-new-order', 
			'admin-cancelled-order', 
			'admin-failed-order', 
			'customer-on-hold-order', 
			'customer-processing-order', 
			'customer-completed-order', 
			'customer-refunded-order', 
			'customer-invoice', 
			'customer-note', 
			'customer-reset-password', 
			'customer-new-account', 
		];

		foreach( $css_files as $file ) {
			wp_enqueue_style( "cd-email-{$file}", plugins_url( "assets/css/{$file}.css", __FILE__ ), '', $this->version, 'all' );
		}

		wp_enqueue_media();
	}

	public function generate_global_order_id( $order_id, $order ) {
		global $cd_order_id;

		$cd_order_id = $order_id;
	}

	public function replace_placeholders( $string, $args ) {
		$placeholders = [
			'%%order_id%%'      	=> isset( $args['order_id'] ) ? $args['order_id'] : '',
			'%%user_name%%'     	=> isset( $args['user_name'] ) ? $args['user_name'] : '',
			'%%status%%'        	=> isset( $args['status'] ) ? $args['status'] : '',
			'%%date%%'          	=> isset( $args['date'] ) ? $args['date'] : '',
			'%%website_link%%'  	=> '<a href="'. site_url() .'"> ' . get_bloginfo('title') .'</a>',
			'%%note_to_customer%%'	=> isset( $args['note_to_customer'] ) ? $args['note_to_customer'] : '',
			'%%order_notes%%'	    => isset( $args['order_notes'] ) ? $args['order_notes'] : '',
			'%%admin_name%%'        => isset( $args['admin_name'] ) ? $args['admin_name'] : '' ,
		];
	
		return str_replace( array_keys( $placeholders ), array_values( $placeholders ), $string );
	}	

	public function test_email() {

		if( ! class_exists( 'Email' ) ) {
			include_once dirname( WC_PLUGIN_FILE ) . '/includes/emails/class-wc-email.php';
		}

		$response = [];

        if( !wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
            $response['status']		= 0;
            $response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
            wp_send_json( $response );
        }

        extract( $_POST );

        $subject 	= __( 'Test Email', 'codesigner-pro' );
        $html 		= Elementor::$instance->frontend->get_builder_content( $template_id );

        $wc_email 	= new \WC_Email();

        $_email 	= new Email_Templates( $this->plugin );

        $_REQUEST['template_id'] = $template_id;
        add_filter( 'woocommerce_email_styles', [ $_email, 'test_email_css' ], 11, 2 );

        $wc_email->send( $email, $subject, $html, '', [] );


		$response['status'] 	= 1;
		$response['message'] 	= __( 'Send Email Successfully', 'codesigner-pro' );
		wp_send_json( $response );
	}

	public function test_email_css( $styles, $object ) {
	    $template_id = codesigner_sanitize_number( $_REQUEST['template_id'] );
	    ob_start();
	    echo wcd_get_template_css( $template_id );
	    return ob_get_clean();
	}

}